<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();

echo "<h2>🔍 Test d'authentification</h2>";

// 1. Vérifier la session
echo "<p><strong>Session ID :</strong> " . session_id() . "</p>";
echo "<p><strong>User ID en session :</strong> " . ($_SESSION['user_id'] ?? 'aucun') . "</p>";
echo "<p><strong>Rôle en session :</strong> " . ($_SESSION['role'] ?? 'non défini') . "</p>";

// 2. Charger Auth
if (file_exists('../src/config/auth.php')) {
    echo "<p>✅ Fichier auth.php trouvé</p>";
    require_once '../src/config/auth.php';
    $auth = new Auth();

    if ($auth->isLoggedIn()) {
        echo "<p>✅ Utilisateur connecté</p>";
        $user = $auth->user();
        echo "<pre>User DB: "; print_r($user); echo "</pre>";
        echo "<p>Rôle dans la base : <strong>" . ($user['role'] ?? 'inconnu') . "</strong></p>";
    } else {
        echo "<p>❌ Non connecté</p>";
    }
} else {
    echo "<p>❌ Fichier ../src/config/auth.php non trouvé !</p>";
}
?>