<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once '../src/config/auth.php';
$auth = new Auth();

if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}

if (!$auth->hasRole(['tresorier', 'admin'])) {
    die("Accès refusé.");
}

$db = (new Database())->getConnection();

// Mois et année
$mois = $_GET['mois'] ?? date('m');
$annee = $_GET['annee'] ?? date('Y');

// Requête pour les encaissements par type
$types = ['ordinaire', 'missionnaire', 'parcelle', 'autre'];
$rapport = [];

foreach ($types as $type) {
    $stmt = $db->prepare("
        SELECT 
            SUM(montant_cdf) as total_cdf
        FROM offrandes 
        WHERE type = ? 
          AND MONTH(date_encaissement) = ?
          AND YEAR(date_encaissement) = ?
    ");
    $stmt->execute([$type, $mois, $annee]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $rapport[$type] = $row['total_cdf'] ?? 0;
}

// Dépenses par compte
$depenses = [];
$comptes = ['ordinaire', 'missionnaire'];
foreach ($comptes as $compte) {
    $stmt = $db->prepare("
        SELECT SUM(montant_cdf) as total 
        FROM depenses 
        WHERE compte = ? 
          AND MONTH(date_depense) = ?
          AND YEAR(date_depense) = ?
    ");
    $stmt->execute([$compte, $mois, $annee]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $depenses[$compte] = $row['total'] ?? 0;
}

// Total général
$total_offrandes = array_sum($rapport);
$total_depenses = array_sum($depenses);
$bilan = $total_offrandes - $total_depenses;
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <title>Rapports Mensuels - Goshen Tabernacle</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-100 text-gray-900 font-sans">
    <?php include 'partials/sidebar.php'; ?>

    <main class="ml-64 p-6">
        <div class="max-w-4xl mx-auto">
            <h1 class="text-2xl font-bold mb-6">📈 Rapport Mensuel</h1>

            <!-- Sélecteur de mois -->
            <form method="GET" class="mb-6 flex gap-4 items-end">
                <div>
                    <label>Mois</label>
                    <select name="mois" class="border p-2 rounded">
                        <?php for ($m = 1; $m <= 12; $m++): ?>
                            <option value="<?= $m ?>" <?= $m == $mois ? 'selected' : '' ?>>
                                <?= date('F', mktime(0, 0, 0, $m)) ?>
                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div>
                    <label>Année</label>
                    <input type="number" name="annee" value="<?= $annee ?>" min="2020" max="2030"
                           class="border p-2 rounded" />
                </div>
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded">
                    <i class="fas fa-sync"></i> Actualiser
                </button>
            </form>

            <!-- Résumé -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <div class="bg-white p-6 rounded shadow text-center">
                    <h3 class="text-gray-600">Total Offrandes</h3>
                    <p class="text-2xl font-bold"><?= number_format($total_offrandes, 0, ',', ' ') ?> CDF</p>
                </div>
                <div class="bg-white p-6 rounded shadow text-center">
                    <h3 class="text-gray-600">Dépenses</h3>
                    <p class="text-2xl font-bold text-red-600"><?= number_format($total_depenses, 0, ',', ' ') ?> CDF</p>
                </div>
                <div class="bg-white p-6 rounded shadow text-center">
                    <h3 class="text-gray-600">Bilan</h3>
                    <p class="text-2xl font-bold <?= $bilan >= 0 ? 'text-green-600' : 'text-red-600' ?>">
                        <?= number_format($bilan, 0, ',', ' ') ?> CDF
                    </p>
                </div>
            </div>

            <!-- Détails -->
            <div class="bg-white p-6 rounded shadow mb-6">
                <h2 class="text-xl font-bold mb-4">Encaissements par Type</h2>
                <table class="w-full border-collapse">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="border p-2 text-left">Type</th>
                            <th class="border p-2 text-right">Montant (CDF)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr><td>Offrandes Ordinaires</td><td class="text-right"><?= number_format($rapport['ordinaire'], 0, ',', ' ') ?></td></tr>
                        <tr><td>Offrandes Missionnaires</td><td class="text-right"><?= number_format($rapport['missionnaire'], 0, ',', ' ') ?></td></tr>
                        <tr><td>Offrandes Achat Parcelle</td><td class="text-right"><?= number_format($rapport['parcelle'], 0, ',', ' ') ?></td></tr>
                        <tr><td>Autres Offrandes</td><td class="text-right"><?= number_format($rapport['autre'], 0, ',', ' ') ?></td></tr>
                    </tbody>
                </table>
            </div>

            <div class="bg-white p-6 rounded shadow">
                <h2 class="text-xl font-bold mb-4">Dépenses par Compte</h2>
                <table class="w-full border-collapse">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="border p-2 text-left">Compte</th>
                            <th class="border p-2 text-right">Montant (CDF)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr><td>Offrandes Ordinaires</td><td class="text-right"><?= number_format($depenses['ordinaire'], 0, ',', ' ') ?></td></tr>
                        <tr><td>Offrandes Missionnaires</td><td class="text-right"><?= number_format($depenses['missionnaire'], 0, ',', ' ') ?></td></tr>
                    </tbody>
                </table>
            </div>

            <!-- Bouton Export PDF -->
            <div class="mt-6 text-right">
                <a href="export-pdf.php?mois=<?= $mois ?>&annee=<?= $annee ?>" 
                   target="_blank" 
                   class="bg-red-600 hover:bg-red-700 text-white px-6 py-2 rounded inline-flex items-center">
                    <i class="fas fa-file-pdf mr-2"></i> Exporter en PDF
                </a>
            </div>
        </div>
    </main>
</body>
</html>