<?php

// Étape 3 : Charger l'authentification
require_once '../src/config/auth.php';
$auth = new Auth();

// Étape 4 : Vérifier si connecté
if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}

// Étape 5 : Déboguer la session
echo "<pre>🔍 DEBUG SESSION: ";
var_dump($_SESSION);
echo "</pre>";

// Étape 6 : Vérifier le rôle
if (!$auth->hasRole(['tresorier', 'admin'])) {
    die("<h1>❌ Accès refusé</h1>
         <p>Votre rôle actuel : <strong>" . ($_SESSION['role'] ?? 'non défini') . "</strong></p>
         <p>Seuls les rôles <strong>tresorier</strong> ou <strong>admin</strong> peuvent accéder à cette page.</p>");
}


// Activer l'affichage des erreurs (développement)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Charger l'authentification
require_once '../src/config/auth.php';
$auth = new Auth();

// Vérifier si connecté
if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit;
}

// Vérifier le rôle : trésorier ou admin uniquement
if (!$auth->hasRole(['tresorier', 'admin'])) {
    die("<h1>Accès refusé</h1><p>Vous n'avez pas les droits pour accéder à cette page.</p>");
}

$user = $auth->user();

// Connexion à la base
$db = (new Database())->getConnection();

$message = '';
$error = '';

// Traitement du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $type = $_POST['type'] ?? '';
    $montant_cdf = floatval($_POST['montant_cdf'] ?? 0);
    $montant_usd = floatval($_POST['montant_usd'] ?? 0);

    // Validation
    $types_valides = ['ordinaire', 'missionnaire', 'parcelle', 'autre'];
    if (!in_array($type, $types_valides)) {
        $error = "Type d'offrande invalide.";
    } elseif ($montant_cdf <= 0 && $montant_usd <= 0) {
        $error = "Le montant doit être supérieur à 0 (CDF ou USD).";
    } else {
        try {
            $stmt = $db->prepare("INSERT INTO offrandes (type, montant_cdf, montant_usd) VALUES (?, ?, ?)");
            $stmt->execute([$type, $montant_cdf, $montant_usd]);
            $message = "✅ Offrande enregistrée avec succès !";
        } catch (Exception $e) {
            $error = "Erreur : " . $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Encaissement - Goshen Tabernacle</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-100 text-gray-900 font-sans">

    <!-- Sidebar -->
    <?php include 'partials/sidebar.php'; ?>

    <!-- Contenu Principal -->
    <main class="ml-64 p-6">
        <div class="max-w-4xl mx-auto">
            <h1 class="text-2xl font-bold mb-6">💰 Enregistrement d'une Offrande</h1>

            <!-- Messages -->
            <?php if ($message): ?>
                <div class="bg-green-100 text-green-800 p-4 rounded mb-6">
                    <?= htmlspecialchars($message) ?>
                </div>
            <?php endif; ?>
            <?php if ($error): ?>
                <div class="bg-red-100 text-red-800 p-4 rounded mb-6">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <!-- Formulaire -->
            <form method="POST" class="bg-white p-8 rounded shadow">
                <div class="mb-6">
                    <label class="block mb-2 font-medium">Type d'offrande</label>
                    <select name="type" required class="border p-3 w-full rounded focus:ring-2 focus:ring-blue-500">
                        <option value="">Sélectionner un type</option>
                        <option value="ordinaire">Offrandes Ordinaires</option>
                        <option value="missionnaire">Offrandes Missionnaires</option>
                        <option value="parcelle">Offrandes Achat Parcelle</option>
                        <option value="autre">Autres Offrandes</option>
                    </select>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label class="block mb-2">Montant en CDF</label>
                        <div class="flex items-center">
                            <span class="bg-gray-200 px-3 py-3 rounded-l border-y border-l border-gray-300">CDF</span>
                            <input
                                type="number"
                                name="montant_cdf"
                                step="0.01"
                                min="0"
                                value="0"
                                class="border p-3 w-full rounded-r focus:ring-2 focus:ring-blue-500"
                            />
                        </div>
                    </div>
                    <div>
                        <label class="block mb-2">Montant en USD</label>
                        <div class="flex items-center">
                            <span class="bg-gray-200 px-3 py-3 rounded-l border-y border-l border-gray-300">$</span>
                            <input
                                type="number"
                                name="montant_usd"
                                step="0.01"
                                min="0"
                                value="0"
                                class="border p-3 w-full rounded-r focus:ring-2 focus:ring-blue-500"
                            />
                        </div>
                    </div>
                </div>

                <div class="flex gap-4">
                    <button
                        type="submit"
                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded font-medium transition"
                    >
                        <i class="fas fa-save mr-2"></i> Enregistrer Offrande
                    </button>
                    <a
                        href="index.php"
                        class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-3 rounded font-medium transition"
                    >
                        <i class="fas fa-arrow-left mr-2"></i> Retour
                    </a>
                </div>
            </form>

            <!-- Historique des offrandes -->
            <div class="mt-10 bg-white p-6 rounded shadow">
                <h2 class="text-xl font-bold mb-4">📜 Dernières Offrandes</h2>
                <table class="w-full border-collapse text-sm">
                    <thead>
                        <tr class="bg-gray-100">
                            <th class="border p-2 text-left">Type</th>
                            <th class="border p-2 text-right">CDF</th>
                            <th class="border p-2 text-right">USD</th>
                            <th class="border p-2 text-right">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $stmt = $db->query("SELECT * FROM offrandes ORDER BY date_encaissement DESC LIMIT 10");
                        $offrandes = $stmt->fetchAll(PDO::FETCH_ASSOC);

                        if (empty($offrandes)): ?>
                            <tr>
                                <td colspan="4" class="text-center p-4 text-gray-500">Aucune offrande enregistrée.</td>
                            </tr>
                        <?php else:
                            foreach ($offrandes as $o): ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="border p-2"><?= ucfirst($o['type']) ?></td>
                                    <td class="border p-2 text-right"><?= number_format($o['montant_cdf'], 2, ',', ' ') ?></td>
                                    <td class="border p-2 text-right"><?= number_format($o['montant_usd'], 2, ',', ' ') ?></td>
                                    <td class="border p-2 text-right"><?= (new DateTime($o['date_encaissement']))->format('d/m/Y H:i') ?></td>
                                </tr>
                            <?php endforeach;
                        endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

</body>
</html>