<?php
// public/appels-de-fond.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once '../src/config/auth.php';
$auth = new Auth();

if (!$auth->isLoggedIn() || !$auth->hasRole(['admin'])) {
    die("<h1>Accès refusé</h1><p>Vous n'avez pas les droits pour accéder à cette page.</p>");
}

$db = (new Database())->getConnection();
$message = '';

// Ajouter un nouvel appel de fond
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_appel'])) {
    $titre = trim($_POST['titre']);
    $description = trim($_POST['description'] ?? '');
    $objectif_cdf = floatval($_POST['objectif_cdf'] ?? 0);
    $objectif_usd = floatval($_POST['objectif_usd'] ?? 0);
    $date_debut = $_POST['date_debut'];
    $date_fin = $_POST['date_fin'];

    if ($titre) {
        try {
            $stmt = $db->prepare("
                INSERT INTO appels_de_fond 
                (titre, description, objectif_cdf, objectif_usd, date_debut, date_fin) 
                VALUES (?, ?, ?, ?, ?, ?)
            ");
            $stmt->execute([$titre, $description, $objectif_cdf, $objectif_usd, $date_debut, $date_fin]);
            $message = "✅ Appel de fond ajouté avec succès !";
        } catch (Exception $e) {
            $message = "❌ Erreur : " . $e->getMessage();
        }
    } else {
        $message = "❌ Le titre est obligatoire.";
    }
}

// Récupérer tous les appels
$stmt = $db->query("SELECT * FROM appels_de_fond ORDER BY date_debut DESC");
$appels = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Appels de Fond - Goshen Tabernacle</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-100 text-gray-900 font-sans">

    <!-- Sidebar -->
    <?php include 'partials/sidebar.php'; ?>

    <!-- Contenu Principal -->
    <main class="ml-64 p-6">
        <div class="max-w-4xl mx-auto">
            <h1 class="text-2xl font-bold mb-6">📢 Gestion des Appels de Fond</h1>

            <?php if ($message): ?>
                <div class="p-4 mb-6 rounded <?= strpos($message, 'Erreur') !== false ? 'bg-red-100 text-red-800' : 'bg-green-100 text-green-800' ?>">
                    <?= htmlspecialchars($message) ?>
                </div>
            <?php endif; ?>

            <!-- Formulaire d'ajout -->
            <div class="bg-white p-6 rounded shadow mb-8">
                <h2 class="text-xl font-bold mb-4">➕ Nouvel Appel de Fond</h2>
                <form method="POST" class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <input type="text" name="titre" placeholder="Titre de l'appel" required class="border p-3 rounded" />
                    <input type="text" name="description" placeholder="Description (optionnel)" class="border p-3 rounded" />
                    <input type="number" name="objectif_cdf" placeholder="Objectif en CDF" class="border p-3 rounded" />
                    <input type="number" name="objectif_usd" step="0.01" placeholder="Objectif en USD" class="border p-3 rounded" />
                    <input type="date" name="date_debut" class="border p-3 rounded" />
                    <input type="date" name="date_fin" class="border p-3 rounded" />
                    <input type="hidden" name="add_appel" value="1" />
                    <button type="submit" class="bg-blue-600 text-white px-4 py-3 rounded col-span-2">
                        <i class="fas fa-plus"></i> Créer l'Appel
                    </button>
                </form>
            </div>

            <!-- Liste des appels -->
            <div class="bg-white p-6 rounded shadow">
                <h2 class="text-xl font-bold mb-4">📋 Tous les Appels de Fond</h2>
                <table class="w-full border-collapse text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="border p-2 text-left">Titre</th>
                            <th class="border p-2 text-left">Objectif</th>
                            <th class="border p-2 text-left">Dates</th>
                            <th class="border p-2 text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($appels as $a): ?>
                        <tr class="hover:bg-gray-50">
                            <td class="border p-2 font-medium"><?= htmlspecialchars($a['titre']) ?></td>
                            <td class="border p-2">
                                <?= number_format($a['objectif_cdf'], 0, ',', ' ') ?> CDF<br>
                                <?= number_format($a['objectif_usd'], 2) ?> USD
                            </td>
                            <td class="border p-2 text-sm">
                                <?= $a['date_debut'] ?> → <?= $a['date_fin'] ?>
                            </td>
                            <td class="border p-2 text-center">
                                <a href="dons-parcelle.php?appel_id=<?= $a['id'] ?>" class="text-blue-600 hover:underline">
                                    <i class="fas fa-eye"></i> Voir
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</body>
</html>