<?php
// install.php - Script d'installation automatique de Goshen Tabernacle

// Empêcher l'accès direct si l'installation est déjà faite
if (file_exists('installed.lock')) {
    die('<h1 style="color: orange;">⚠️ Installation déjà effectuée !</h1>
         <p>Pour réinstaller, supprimez le fichier <strong>installed.lock</strong> manuellement.</p>');
}

// Configuration de la base de données (à adapter)
$host = 'localhost';
$dbname = 'goshen_tabernacle'; // Changez si besoin
$username = 'root';           // À modifier selon votre serveur
$password = '';               // À modifier selon votre serveur

// Connexion PDO
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
    echo "<p>✅ Connexion à la base de données <strong>$dbname</strong> réussie.</p>";
} catch (PDOException $e) {
    // Si la base n'existe pas, on essaie de la créer
    try {
        $pdo = new PDO("mysql:host=$host;charset=utf8", $username, $password);
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        $pdo->exec("USE `$dbname`");
        echo "<p>✅ Base de données <strong>$dbname</strong> créée avec succès.</p>";
    } catch (PDOException $ex) {
        die("<h1 style='color: red;'>❌ Impossible de créer la base de données :</h1><pre>" . $ex->getMessage() . "</pre>");
    }
}

// Si on arrive ici, on est connecté à la base
$pdo->exec("USE `$dbname`");

// Requêtes SQL pour créer les tables
$sqlQueries = [
    // Table offrandes
    "CREATE TABLE IF NOT EXISTS offrandes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        type VARCHAR(50) NOT NULL,
        montant_cdf DECIMAL(15,2) DEFAULT 0.00,
        montant_usd DECIMAL(15,2) DEFAULT 0.00,
        date_encaissement DATETIME DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",

    // Table depenses
    "CREATE TABLE IF NOT EXISTS depenses (
        id INT AUTO_INCREMENT PRIMARY KEY,
        compte VARCHAR(50) NOT NULL,
        description TEXT NOT NULL,
        montant_cdf DECIMAL(15,2) DEFAULT 0.00,
        montant_usd DECIMAL(15,2) DEFAULT 0.00,
        date_depense DATETIME DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",

    // Table dons
    "CREATE TABLE IF NOT EXISTS dons (
        id INT AUTO_INCREMENT PRIMARY KEY,
        nom_donateur VARCHAR(100) NOT NULL,
        montant_cdf DECIMAL(15,2) DEFAULT 0.00,
        montant_usd DECIMAL(15,2) DEFAULT 0.00,
        date_engagement DATETIME DEFAULT CURRENT_TIMESTAMP,
        statut ENUM('en_cours', 'complet') DEFAULT 'en_cours'
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",

    // Table articles (patrimoine)
    "CREATE TABLE IF NOT EXISTS articles (
        id INT AUTO_INCREMENT PRIMARY KEY,
        categorie VARCHAR(50) NOT NULL,
        nom VARCHAR(100) NOT NULL,
        marque VARCHAR(100),
        couleur VARCHAR(50),
        quantite INT DEFAULT 1,
        date_ajout DATETIME DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",

    // Table maintenances
    "CREATE TABLE IF NOT EXISTS maintenances (
        id INT AUTO_INCREMENT PRIMARY KEY,
        equipement VARCHAR(100) NOT NULL,
        description TEXT,
        date_prevue DATE NOT NULL,
        date_reelle DATE NULL,
        statut ENUM('planifié', 'effectué', 'reporté') DEFAULT 'planifié'
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;"
];

// Exécution des requêtes
foreach ($sqlQueries as $query) {
    try {
        $pdo->exec($query);
    } catch (PDOException $e) {
        echo "<p style='color: orange;'>⚠️ Problème avec une table : " . $e->getMessage() . "</p>";
    }
}

// (Optionnel) Données de test
$seed = true; // Mettez à false si vous ne voulez pas de données de test

if ($seed) {
    $pdo->exec("INSERT INTO offrandes (type, montant_cdf, montant_usd) VALUES 
        ('ordinaire', 150000, 100),
        ('missionnaire', 75000, 50),
        ('parcelle', 200000, 0)
    ");

    $pdo->exec("INSERT INTO dons (nom_donateur, montant_cdf, statut) VALUES 
        ('Jean Mulumba', 100000, 'en_cours'),
        ('Marie Kanza', 150000, 'complet')
    ");

    $pdo->exec("INSERT INTO articles (categorie, nom, marque, couleur, quantite) VALUES 
        ('chaise', 'Chaise pliante', 'Robust', 'Noir', 120),
        ('microphone', 'Micro sans fil', 'Sennheiser', 'Gris', 4)
    ");

    echo "<p>🌱 Données de test ajoutées.</p>";
}

// Créer un fichier de verrou pour éviter une réinstallation
file_put_contents('installed.lock', 'Goshen Tabernacle installé le ' . date('Y-m-d H:i:s'));

// Message de succès
echo "
<h1 style='color: #10B981;'>🎉 Installation réussie !</h1>
<p>✅ Toutes les tables ont été créées dans la base <strong>$dbname</strong>.</p>
<p>✅ Données de test ajoutées (optionnel).</p>
<p>🔒 Un fichier <strong>installed.lock</strong> a été créé pour bloquer les réinstallations.</p>
<hr>
<h3>➡️ Prochaines étapes :</h3>
<ul>
    <li>Supprimez ou renommez <code>install.php</code> pour des raisons de sécurité.</li>
    <li>Configurez votre <code>db.php</code> pour utiliser cette base.</li>
    <li>Accédez à votre <a href='index.php'>dashboard</a>.</li>
</ul>
";