<?php
 namespace MailPoetVendor\Symfony\Component\DependencyInjection\Compiler; if (!defined('ABSPATH')) exit; use MailPoetVendor\Symfony\Component\DependencyInjection\Exception\InvalidArgumentException; class ServiceReferenceGraph { private $nodes = []; public function hasNode(string $id) : bool { return isset($this->nodes[$id]); } public function getNode(string $id) : ServiceReferenceGraphNode { if (!isset($this->nodes[$id])) { throw new InvalidArgumentException(\sprintf('There is no node with id "%s".', $id)); } return $this->nodes[$id]; } public function getNodes() : array { return $this->nodes; } public function clear() { foreach ($this->nodes as $node) { $node->clear(); } $this->nodes = []; } public function connect(?string $sourceId, $sourceValue, ?string $destId, $destValue = null, $reference = null, bool $lazy = \false, bool $weak = \false, bool $byConstructor = \false) { if (null === $sourceId || null === $destId) { return; } $sourceNode = $this->createNode($sourceId, $sourceValue); $destNode = $this->createNode($destId, $destValue); $edge = new ServiceReferenceGraphEdge($sourceNode, $destNode, $reference, $lazy, $weak, $byConstructor); $sourceNode->addOutEdge($edge); $destNode->addInEdge($edge); } private function createNode(string $id, $value) : ServiceReferenceGraphNode { if (isset($this->nodes[$id]) && $this->nodes[$id]->getValue() === $value) { return $this->nodes[$id]; } return $this->nodes[$id] = new ServiceReferenceGraphNode($id, $value); } } 