<?php
 namespace MailPoetVendor\Symfony\Component\DependencyInjection\Compiler; if (!defined('ABSPATH')) exit; use MailPoetVendor\Symfony\Component\DependencyInjection\Exception\InvalidArgumentException; class PassConfig { public const TYPE_AFTER_REMOVING = 'afterRemoving'; public const TYPE_BEFORE_OPTIMIZATION = 'beforeOptimization'; public const TYPE_BEFORE_REMOVING = 'beforeRemoving'; public const TYPE_OPTIMIZE = 'optimization'; public const TYPE_REMOVE = 'removing'; private $mergePass; private $afterRemovingPasses = []; private $beforeOptimizationPasses = []; private $beforeRemovingPasses = []; private $optimizationPasses; private $removingPasses; public function __construct() { $this->mergePass = new MergeExtensionConfigurationPass(); $this->beforeOptimizationPasses = [100 => [new ResolveClassPass(), new ResolveInstanceofConditionalsPass(), new RegisterEnvVarProcessorsPass()], -1000 => [new ExtensionCompilerPass()]]; $this->optimizationPasses = [[new ValidateEnvPlaceholdersPass(), new ResolveChildDefinitionsPass(), new RegisterServiceSubscribersPass(), new ResolveParameterPlaceHoldersPass(\false, \false), new ResolveFactoryClassPass(), new ResolveNamedArgumentsPass(), new AutowireRequiredMethodsPass(), new ResolveBindingsPass(), new ServiceLocatorTagPass(), new DecoratorServicePass(), new CheckDefinitionValidityPass(), new AutowirePass(\false), new ResolveTaggedIteratorArgumentPass(), new ResolveServiceSubscribersPass(), new ResolveReferencesToAliasesPass(), new ResolveInvalidReferencesPass(), new AnalyzeServiceReferencesPass(\true), new CheckCircularReferencesPass(), new CheckReferenceValidityPass(), new CheckArgumentsValidityPass(\false)]]; $this->beforeRemovingPasses = [-100 => [new ResolvePrivatesPass()]]; $this->removingPasses = [[new RemovePrivateAliasesPass(), new ReplaceAliasByActualDefinitionPass(), new RemoveAbstractDefinitionsPass(), new RemoveUnusedDefinitionsPass(), new AnalyzeServiceReferencesPass(), new CheckExceptionOnInvalidReferenceBehaviorPass(), new InlineServiceDefinitionsPass(new AnalyzeServiceReferencesPass()), new AnalyzeServiceReferencesPass(), new DefinitionErrorExceptionPass()]]; $this->afterRemovingPasses = [[new ResolveHotPathPass()]]; } public function getPasses() { return \array_merge([$this->mergePass], $this->getBeforeOptimizationPasses(), $this->getOptimizationPasses(), $this->getBeforeRemovingPasses(), $this->getRemovingPasses(), $this->getAfterRemovingPasses()); } public function addPass(CompilerPassInterface $pass, $type = self::TYPE_BEFORE_OPTIMIZATION, int $priority = 0) { $property = $type . 'Passes'; if (!isset($this->{$property})) { throw new InvalidArgumentException(\sprintf('Invalid type "%s".', $type)); } $passes =& $this->{$property}; if (!isset($passes[$priority])) { $passes[$priority] = []; } $passes[$priority][] = $pass; } public function getAfterRemovingPasses() { return $this->sortPasses($this->afterRemovingPasses); } public function getBeforeOptimizationPasses() { return $this->sortPasses($this->beforeOptimizationPasses); } public function getBeforeRemovingPasses() { return $this->sortPasses($this->beforeRemovingPasses); } public function getOptimizationPasses() { return $this->sortPasses($this->optimizationPasses); } public function getRemovingPasses() { return $this->sortPasses($this->removingPasses); } public function getMergePass() { return $this->mergePass; } public function setMergePass(CompilerPassInterface $pass) { $this->mergePass = $pass; } public function setAfterRemovingPasses(array $passes) { $this->afterRemovingPasses = [$passes]; } public function setBeforeOptimizationPasses(array $passes) { $this->beforeOptimizationPasses = [$passes]; } public function setBeforeRemovingPasses(array $passes) { $this->beforeRemovingPasses = [$passes]; } public function setOptimizationPasses(array $passes) { $this->optimizationPasses = [$passes]; } public function setRemovingPasses(array $passes) { $this->removingPasses = [$passes]; } private function sortPasses(array $passes) : array { if (0 === \count($passes)) { return []; } \krsort($passes); return \array_merge(...$passes); } } 