<?php
 namespace MailPoetVendor\Doctrine\ORM\Internal\Hydration; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\Driver\ResultStatement; use MailPoetVendor\Doctrine\DBAL\FetchMode; use MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform; use MailPoetVendor\Doctrine\DBAL\Types\Type; use MailPoetVendor\Doctrine\Deprecations\Deprecation; use MailPoetVendor\Doctrine\ORM\EntityManagerInterface; use MailPoetVendor\Doctrine\ORM\Events; use MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata; use MailPoetVendor\Doctrine\ORM\Query\ResultSetMapping; use MailPoetVendor\Doctrine\ORM\Tools\Pagination\LimitSubqueryWalker; use MailPoetVendor\Doctrine\ORM\UnitOfWork; use Generator; use PDO; use ReflectionClass; use function array_map; use function array_merge; use function count; use function end; use function in_array; abstract class AbstractHydrator { protected $_rsm; protected $_em; protected $_platform; protected $_uow; protected $_metadataCache = []; protected $_cache = []; protected $_stmt; protected $_hints; public function __construct(EntityManagerInterface $em) { $this->_em = $em; $this->_platform = $em->getConnection()->getDatabasePlatform(); $this->_uow = $em->getUnitOfWork(); } public function iterate($stmt, $resultSetMapping, array $hints = []) { Deprecation::trigger('doctrine/orm', 'https://github.com/doctrine/orm/issues/8463', 'Method %s() is deprecated and will be removed in Doctrine ORM 3.0. Use toIterable() instead.', __METHOD__); $this->_stmt = $stmt; $this->_rsm = $resultSetMapping; $this->_hints = $hints; $evm = $this->_em->getEventManager(); $evm->addEventListener([Events::onClear], $this); $this->prepare(); return new IterableResult($this); } public function toIterable(ResultStatement $stmt, ResultSetMapping $resultSetMapping, array $hints = []) : iterable { $this->_stmt = $stmt; $this->_rsm = $resultSetMapping; $this->_hints = $hints; $evm = $this->_em->getEventManager(); $evm->addEventListener([Events::onClear], $this); $this->prepare(); while (\true) { $row = $this->_stmt->fetch(FetchMode::ASSOCIATIVE); if ($row === \false || $row === null) { $this->cleanup(); break; } $result = []; $this->hydrateRowData($row, $result); $this->cleanupAfterRowIteration(); if (count($result) === 1) { (yield end($result)); } else { (yield $result); } } } public function hydrateAll($stmt, $resultSetMapping, array $hints = []) { $this->_stmt = $stmt; $this->_rsm = $resultSetMapping; $this->_hints = $hints; $this->_em->getEventManager()->addEventListener([Events::onClear], $this); $this->prepare(); try { $result = $this->hydrateAllData(); } finally { $this->cleanup(); } return $result; } public function hydrateRow() { $row = $this->_stmt->fetch(PDO::FETCH_ASSOC); if ($row === \false || $row === null) { $this->cleanup(); return \false; } $result = []; $this->hydrateRowData($row, $result); return $result; } public function onClear($eventArgs) { } protected function prepare() { } protected function cleanup() { $this->_stmt->closeCursor(); $this->_stmt = null; $this->_rsm = null; $this->_cache = []; $this->_metadataCache = []; $this->_em->getEventManager()->removeEventListener([Events::onClear], $this); } protected function cleanupAfterRowIteration() : void { } protected function hydrateRowData(array $row, array &$result) { throw new HydrationException('hydrateRowData() not implemented by this hydrator.'); } protected abstract function hydrateAllData(); protected function gatherRowData(array $data, array &$id, array &$nonemptyComponents) { $rowData = ['data' => []]; foreach ($data as $key => $value) { $cacheKeyInfo = $this->hydrateColumnInfo($key); if ($cacheKeyInfo === null) { continue; } $fieldName = $cacheKeyInfo['fieldName']; switch (\true) { case isset($cacheKeyInfo['isNewObjectParameter']): $argIndex = $cacheKeyInfo['argIndex']; $objIndex = $cacheKeyInfo['objIndex']; $type = $cacheKeyInfo['type']; $value = $type->convertToPHPValue($value, $this->_platform); $rowData['newObjects'][$objIndex]['class'] = $cacheKeyInfo['class']; $rowData['newObjects'][$objIndex]['args'][$argIndex] = $value; break; case isset($cacheKeyInfo['isScalar']): $type = $cacheKeyInfo['type']; $value = $type->convertToPHPValue($value, $this->_platform); $rowData['scalars'][$fieldName] = $value; break; default: $dqlAlias = $cacheKeyInfo['dqlAlias']; $type = $cacheKeyInfo['type']; if (isset($cacheKeyInfo['discriminatorColumn'], $data[$cacheKeyInfo['discriminatorColumn']]) && !in_array((string) $data[$cacheKeyInfo['discriminatorColumn']], $cacheKeyInfo['discriminatorValues'], \true)) { break; } if (isset($rowData['data'][$dqlAlias][$fieldName])) { break; } $rowData['data'][$dqlAlias][$fieldName] = $type ? $type->convertToPHPValue($value, $this->_platform) : $value; if ($cacheKeyInfo['isIdentifier'] && $value !== null) { $id[$dqlAlias] .= '|' . $value; $nonemptyComponents[$dqlAlias] = \true; } break; } } return $rowData; } protected function gatherScalarRowData(&$data) { $rowData = []; foreach ($data as $key => $value) { $cacheKeyInfo = $this->hydrateColumnInfo($key); if ($cacheKeyInfo === null) { continue; } $fieldName = $cacheKeyInfo['fieldName']; if (!isset($cacheKeyInfo['isScalar'])) { $type = $cacheKeyInfo['type']; $value = $type ? $type->convertToPHPValue($value, $this->_platform) : $value; $fieldName = $cacheKeyInfo['dqlAlias'] . '_' . $fieldName; } $rowData[$fieldName] = $value; } return $rowData; } protected function hydrateColumnInfo($key) { if (isset($this->_cache[$key])) { return $this->_cache[$key]; } switch (\true) { case isset($this->_rsm->fieldMappings[$key]): $classMetadata = $this->getClassMetadata($this->_rsm->declaringClasses[$key]); $fieldName = $this->_rsm->fieldMappings[$key]; $fieldMapping = $classMetadata->fieldMappings[$fieldName]; $ownerMap = $this->_rsm->columnOwnerMap[$key]; $columnInfo = ['isIdentifier' => in_array($fieldName, $classMetadata->identifier, \true), 'fieldName' => $fieldName, 'type' => Type::getType($fieldMapping['type']), 'dqlAlias' => $ownerMap]; if ($classMetadata->parentClasses && isset($this->_rsm->discriminatorColumns[$ownerMap])) { return $this->_cache[$key] = array_merge($columnInfo, ['discriminatorColumn' => $this->_rsm->discriminatorColumns[$ownerMap], 'discriminatorValue' => $classMetadata->discriminatorValue, 'discriminatorValues' => $this->getDiscriminatorValues($classMetadata)]); } return $this->_cache[$key] = $columnInfo; case isset($this->_rsm->newObjectMappings[$key]): $mapping = $this->_rsm->newObjectMappings[$key]; return $this->_cache[$key] = ['isScalar' => \true, 'isNewObjectParameter' => \true, 'fieldName' => $this->_rsm->scalarMappings[$key], 'type' => Type::getType($this->_rsm->typeMappings[$key]), 'argIndex' => $mapping['argIndex'], 'objIndex' => $mapping['objIndex'], 'class' => new ReflectionClass($mapping['className'])]; case isset($this->_rsm->scalarMappings[$key], $this->_hints[LimitSubqueryWalker::FORCE_DBAL_TYPE_CONVERSION]): return $this->_cache[$key] = ['fieldName' => $this->_rsm->scalarMappings[$key], 'type' => Type::getType($this->_rsm->typeMappings[$key]), 'dqlAlias' => '']; case isset($this->_rsm->scalarMappings[$key]): return $this->_cache[$key] = ['isScalar' => \true, 'fieldName' => $this->_rsm->scalarMappings[$key], 'type' => Type::getType($this->_rsm->typeMappings[$key])]; case isset($this->_rsm->metaMappings[$key]): $fieldName = $this->_rsm->metaMappings[$key]; $dqlAlias = $this->_rsm->columnOwnerMap[$key]; $type = isset($this->_rsm->typeMappings[$key]) ? Type::getType($this->_rsm->typeMappings[$key]) : null; $this->getClassMetadata($this->_rsm->aliasMap[$dqlAlias]); return $this->_cache[$key] = ['isIdentifier' => isset($this->_rsm->isIdentifierColumn[$dqlAlias][$key]), 'isMetaColumn' => \true, 'fieldName' => $fieldName, 'type' => $type, 'dqlAlias' => $dqlAlias]; } return null; } private function getDiscriminatorValues(ClassMetadata $classMetadata) : array { $values = array_map(function (string $subClass) : string { return (string) $this->getClassMetadata($subClass)->discriminatorValue; }, $classMetadata->subClasses); $values[] = (string) $classMetadata->discriminatorValue; return $values; } protected function getClassMetadata($className) { if (!isset($this->_metadataCache[$className])) { $this->_metadataCache[$className] = $this->_em->getClassMetadata($className); } return $this->_metadataCache[$className]; } protected function registerManaged(ClassMetadata $class, $entity, array $data) { if ($class->isIdentifierComposite) { $id = []; foreach ($class->identifier as $fieldName) { $id[$fieldName] = isset($class->associationMappings[$fieldName]) ? $data[$class->associationMappings[$fieldName]['joinColumns'][0]['name']] : $data[$fieldName]; } } else { $fieldName = $class->identifier[0]; $id = [$fieldName => isset($class->associationMappings[$fieldName]) ? $data[$class->associationMappings[$fieldName]['joinColumns'][0]['name']] : $data[$fieldName]]; } $this->_em->getUnitOfWork()->registerManaged($entity, $id, $data); } } 